#define EXPORT extern "C" __declspec(dllexport) 

// dllmain.cpp : Defines the entry point for the DLL application.
#include "stdafx.h"
#include "textfile.h"

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}


EXPORT bool ChangeEncodeUTF8(int codein, int codeout, char* filein, char* fileout);
EXPORT bool ChangeEncodeASCII(int codein, int codeout, char* filein, char* fileout);
EXPORT bool ChangeEncodeUNI16BE(int codein, int codeout, char* filein, char* fileout);
EXPORT bool ChangeEncodeUNI16LE(int codein, int codeout, char* filein, char* fileout);

EXPORT bool ChangeEncodeUTF8(int codein, int codeout, char* filein, char* fileout)
{
	//Necesitamos adaptar los tipos char* a WCHAR* para elllo utilizamos el siguiente procedimiento y la funcnion MultiByteToWideChar
	//-------------------------
	//TYPES IN
	// Find out required string size (if you don't have that info)
	int iRequiredSizeIn = ::MultiByteToWideChar(CP_ACP, NULL, filein, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringIn = new WCHAR[iRequiredSizeIn];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, filein , -1, pwchStringIn, iRequiredSizeIn);
	
	//TYPES OUT
	// Find out required string size (if you don't have that info)
	int iRequiredSizeOut = ::MultiByteToWideChar(CP_ACP, NULL, fileout, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringOut = new WCHAR[iRequiredSizeOut];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, fileout , -1, pwchStringOut, iRequiredSizeOut);
	//-------------------------

	//EMPEZAMOS LA LABOR
	//Make file reader. Read the file
	CTextFileRead reader(pwchStringIn);

	//Define which code-page to use when we read the file
	reader.SetCodePage(codein);

	//Read everything to a Unicode-string
	wstring alltext;
	reader.Read(alltext);

	//Close file
	reader.Close();

	//Now we create a new file
	CTextFileWrite writer(pwchStringOut, CTextFileBase::UTF_8);

	//Set which code-page to use.
	writer.SetCodePage(codeout);

	//Do the writing...
	writer << alltext;

	//Was data lost when was converted to
	if(writer.IsDataLost())
	{
		return false;
	}
	//Close the file
	writer.Close();
	//Ok
	return true;
}


EXPORT bool ChangeEncodeASCII(int codein, int codeout, char* filein, char* fileout)
{

	//Necesitamos adaptar los tipos char* a WCHAR* para elllo utilizamos el siguiente procedimiento y la funcnion MultiByteToWideChar
	//-------------------------
	//TYPES IN
	// Find out required string size (if you don't have that info)
	int iRequiredSizeIn = ::MultiByteToWideChar(CP_ACP, NULL, filein, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringIn = new WCHAR[iRequiredSizeIn];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, filein , -1, pwchStringIn, iRequiredSizeIn);
	
	//TYPES OUT
	// Find out required string size (if you don't have that info)
	int iRequiredSizeOut = ::MultiByteToWideChar(CP_ACP, NULL, fileout, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringOut = new WCHAR[iRequiredSizeOut];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, fileout , -1, pwchStringOut, iRequiredSizeOut);
	//-------------------------

	//EMPEZAMOS LA LABOR
	//Make file reader. Read the file
	CTextFileRead reader(pwchStringIn);

	//Define which code-page to use when we read the file
	reader.SetCodePage(codein);

	//Read everything to a Unicode-string
	wstring alltext;
	reader.Read(alltext);

	//Close file
	reader.Close();

	//Now we create a new file
	CTextFileWrite writer(pwchStringOut, CTextFileBase::ASCII);

	//Set which code-page to use.
	writer.SetCodePage(codeout);

	//Do the writing...
	writer << alltext;

	//Was data lost when was converted to
	if(writer.IsDataLost())
	{
		return false;
	}

	//Close the file
	writer.Close();
	
	//Ok
	return true;
}



EXPORT bool ChangeEncodeUNI16BE(int codein, int codeout, char* filein, char* fileout)
{

	//Necesitamos adaptar los tipos char* a WCHAR* para elllo utilizamos el siguiente procedimiento y la funcnion MultiByteToWideChar
	//-------------------------
	//TYPES IN
	// Find out required string size (if you don't have that info)
	int iRequiredSizeIn = ::MultiByteToWideChar(CP_ACP, NULL, filein, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringIn = new WCHAR[iRequiredSizeIn];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, filein , -1, pwchStringIn, iRequiredSizeIn);
	
	//TYPES OUT
	// Find out required string size (if you don't have that info)
	int iRequiredSizeOut = ::MultiByteToWideChar(CP_ACP, NULL, fileout, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringOut = new WCHAR[iRequiredSizeOut];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, fileout , -1, pwchStringOut, iRequiredSizeOut);
	//-------------------------

	//EMPEZAMOS LA LABOR
	//Make file reader. Read the file
	CTextFileRead reader(pwchStringIn);

	//Define which code-page to use when we read the file
	reader.SetCodePage(codein);

	//Read everything to a Unicode-string
	wstring alltext;
	reader.Read(alltext);

	//Close file
	reader.Close();

	//Now we create a new file
	CTextFileWrite writer(pwchStringOut, CTextFileBase::UNI16_BE);

	//Set which code-page to use.
	writer.SetCodePage(codeout);

	//Do the writing...
	writer << alltext;

	//Was data lost when was converted to
	if(writer.IsDataLost())
	{
		return false;
	}

	//Close the file
	writer.Close();
	
	//Ok
	return true;
}

EXPORT bool ChangeEncodeUNI16LE(int codein, int codeout, char* filein, char* fileout)
{

	//Necesitamos adaptar los tipos char* a WCHAR* para elllo utilizamos el siguiente procedimiento y la funcnion MultiByteToWideChar
	//-------------------------
	//TYPES IN
	// Find out required string size (if you don't have that info)
	int iRequiredSizeIn = ::MultiByteToWideChar(CP_ACP, NULL, filein, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringIn = new WCHAR[iRequiredSizeIn];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, filein , -1, pwchStringIn, iRequiredSizeIn);
	
	//TYPES OUT
	// Find out required string size (if you don't have that info)
	int iRequiredSizeOut = ::MultiByteToWideChar(CP_ACP, NULL, fileout, -1, NULL, 0);
	// Alloc buffer for converted string
	WCHAR* pwchStringOut = new WCHAR[iRequiredSizeOut];
	// Do the string conversion
	::MultiByteToWideChar(CP_ACP, NULL, fileout , -1, pwchStringOut, iRequiredSizeOut);
	//-------------------------

	//EMPEZAMOS LA LABOR
	//Make file reader. Read the file
	CTextFileRead reader(pwchStringIn);

	//Define which code-page to use when we read the file
	reader.SetCodePage(codein);

	//Read everything to a Unicode-string
	wstring alltext;
	reader.Read(alltext);

	//Close file
	reader.Close();

	//Now we create a new file
	CTextFileWrite writer(pwchStringOut, CTextFileBase::UNI16_LE);

	//Set which code-page to use.
	writer.SetCodePage(codeout);

	//Do the writing...
	writer << alltext;

	//Was data lost when was converted to
	if(writer.IsDataLost())
	{
		return false;
	}

	//Close the file
	writer.Close();
	
	//Ok
	return true;
}
