//////////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////

#ifndef __AUDIO_H__
#define __AUDIO_H__

void ws_audio_init(void);
void ws_audio_reset(void);
void ws_audio_port_write(DWORD port,BYTE value);
BYTE ws_audio_port_read(BYTE port);
void ws_audio_done(void);

unsigned int ws_audio_mrand(unsigned int Degree);
int ws_audio_seal_init(void);
void ws_audio_seal_done(void);
int ws_audio_play_channel(int Channel);
int ws_audio_stop_channel(int Channel);
void ws_audio_clear_channel(int Channel);
void ws_audio_set_channel_frequency(int Channel,int Period);
void ws_audio_set_channel_volume(int Channel,int Vol);
void ws_audio_set_channel_pan(int Channel,int Left,int Right);
void ws_audio_set_channel_pdata(int Channel,int Index);
void ws_audio_set_channels_pbuf(int Addr,int Data);
void ws_audio_rst_channel(int Channel);
int ws_audio_int(void);
void ws_audio_set_pcm(int Data);
void ws_audio_flash_pcm(void);
void ws_audio_write_byte(DWORD offset, BYTE value);
void ws_audio_process(void);
void ws_audio_readState(int fp);
void ws_audio_writeState(int fp);


/* audio system version number */
#define AUDIO_SYSTEM_VERSION            0x0106

/* audio capabilities bit fields definitions */
#define AUDIO_FORMAT_1M08               0x00000001
#define AUDIO_FORMAT_1S08               0x00000002
#define AUDIO_FORMAT_1M16               0x00000004
#define AUDIO_FORMAT_1S16               0x00000008
#define AUDIO_FORMAT_2M08               0x00000010
#define AUDIO_FORMAT_2S08               0x00000020
#define AUDIO_FORMAT_2M16               0x00000040
#define AUDIO_FORMAT_2S16               0x00000080
#define AUDIO_FORMAT_4M08               0x00000100
#define AUDIO_FORMAT_4S08               0x00000200
#define AUDIO_FORMAT_4M16               0x00000400
#define AUDIO_FORMAT_4S16               0x00000800

/* audio format bit fields defines for devices and waveforms */
#define AUDIO_FORMAT_8BITS              0x0000
#define AUDIO_FORMAT_16BITS             0x0001
#define AUDIO_FORMAT_LOOP               0x0010
#define AUDIO_FORMAT_BIDILOOP           0x0020
#define AUDIO_FORMAT_REVERSE            0x0080
#define AUDIO_FORMAT_MONO               0x0000
#define AUDIO_FORMAT_STEREO             0x0100
#define AUDIO_FORMAT_FILTER             0x8000

/* audio resource limits defines */
#define AUDIO_MAX_VOICES                32
#define AUDIO_MAX_SAMPLES               16
#define AUDIO_MAX_PATCHES               128
#define AUDIO_MAX_PATTERNS              256
#define AUDIO_MAX_ORDERS                256
#define AUDIO_MAX_NOTES                 96
#define AUDIO_MAX_POINTS                12
#define AUDIO_MIN_PERIOD                1
#define AUDIO_MAX_PERIOD                31999
#define AUDIO_MIN_VOLUME                0x00
#define AUDIO_MAX_VOLUME                0x40
#define AUDIO_MIN_PANNING               0x00
#define AUDIO_MAX_PANNING               0xFF
#define AUDIO_MIN_POSITION              0x00000000L
#define AUDIO_MAX_POSITION              0x00100000L
#define AUDIO_MIN_FREQUENCY             0x00000200L
#define AUDIO_MAX_FREQUENCY             0x00080000L

/* audio error code defines */
#define AUDIO_ERROR_NONE                0x0000
#define AUDIO_ERROR_INVALHANDLE         0x0001
#define AUDIO_ERROR_INVALPARAM          0x0002
#define AUDIO_ERROR_NOTSUPPORTED        0x0003
#define AUDIO_ERROR_BADDEVICEID         0x0004
#define AUDIO_ERROR_NODEVICE            0x0005
#define AUDIO_ERROR_DEVICEBUSY          0x0006
#define AUDIO_ERROR_BADFORMAT           0x0007
#define AUDIO_ERROR_NOMEMORY            0x0008
#define AUDIO_ERROR_NODRAMMEMORY        0x0009
#define AUDIO_ERROR_FILENOTFOUND        0x000A
#define AUDIO_ERROR_BADFILEFORMAT       0x000B
#define AUDIO_LAST_ERROR                0x000B

/* audio device identifiers */
#define AUDIO_DEVICE_NONE               0x0000
#define AUDIO_DEVICE_MAPPER             0xFFFF

/* audio product identifiers */
#define AUDIO_PRODUCT_NONE              0x0000
#define AUDIO_PRODUCT_SB                0x0001
#define AUDIO_PRODUCT_SB15              0x0002
#define AUDIO_PRODUCT_SB20              0x0003
#define AUDIO_PRODUCT_SBPRO             0x0004
#define AUDIO_PRODUCT_SB16              0x0005
#define AUDIO_PRODUCT_AWE32             0x0006
#define AUDIO_PRODUCT_WSS               0x0007
#define AUDIO_PRODUCT_ESS               0x0008
#define AUDIO_PRODUCT_GUS               0x0009
#define AUDIO_PRODUCT_GUSDB             0x000A
#define AUDIO_PRODUCT_GUSMAX            0x000B
#define AUDIO_PRODUCT_IWAVE             0x000C
#define AUDIO_PRODUCT_PAS               0x000D
#define AUDIO_PRODUCT_PAS16             0x000E
#define AUDIO_PRODUCT_ARIA              0x000F
#define AUDIO_PRODUCT_WINDOWS           0x0100
#define AUDIO_PRODUCT_LINUX             0x0101
#define AUDIO_PRODUCT_SPARC             0x0102
#define AUDIO_PRODUCT_SGI               0x0103
#define AUDIO_PRODUCT_DSOUND            0x0104
#define AUDIO_PRODUCT_OS2MMPM           0x0105
#define AUDIO_PRODUCT_OS2DART           0x0106
#define AUDIO_PRODUCT_BEOSR3            0x0107
#define AUDIO_PRODUCT_BEOS              0x0108
#define AUDIO_PRODUCT_QNX               0x0109

/* audio mixer channels */
#define AUDIO_MIXER_MASTER_VOLUME       0x0001
#define AUDIO_MIXER_TREBLE              0x0002
#define AUDIO_MIXER_BASS                0x0003
#define AUDIO_MIXER_CHORUS              0x0004
#define AUDIO_MIXER_REVERB              0x0005

/* audio envelope bit fields */
#define AUDIO_ENVELOPE_ON               0x0001
#define AUDIO_ENVELOPE_SUSTAIN          0x0002
#define AUDIO_ENVELOPE_LOOP             0x0004

/* audio pattern bit fields */
#define AUDIO_PATTERN_PACKED            0x0080
#define AUDIO_PATTERN_NOTE              0x0001
#define AUDIO_PATTERN_SAMPLE            0x0002
#define AUDIO_PATTERN_VOLUME            0x0004
#define AUDIO_PATTERN_COMMAND           0x0008
#define AUDIO_PATTERN_PARAMS            0x0010

/* audio module bit fields */
#define AUDIO_MODULE_AMIGA              0x0000
#define AUDIO_MODULE_LINEAR             0x0001
#define AUDIO_MODULE_PANNING            0x8000

/* audio capabilities structure */
typedef struct {
    WORD    wProductId;                         /* product identifier */
    CHAR    szProductName[30];                  /* product name */
    DWORD   dwFormats;                          /* formats supported */
} AUDIOCAPS, *LPAUDIOCAPS;

/* audio format structure */
typedef struct {
    UINT    nDeviceId;                          /* device identifier */
    WORD    wFormat;                            /* playback format */
    WORD    nSampleRate;                        /* sampling frequency */
} AUDIOINFO, *LPAUDIOINFO;

/* audio waveform structure */
typedef struct {
    LPBYTE  lpData;                             /* data pointer */
    DWORD   dwHandle;                           /* waveform handle */
    DWORD   dwLength;                           /* waveform length */
    DWORD   dwLoopStart;                        /* loop start point */
    DWORD   dwLoopEnd;                          /* loop end point */
    WORD    nSampleRate;                        /* sampling rate */
    WORD    wFormat;                            /* format bits */
} AUDIOWAVE, *LPAUDIOWAVE;

/* audio handle defines */
typedef HANDLE  HAC;

#endif