/* ================================================================
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 */ 

#ifndef __GAMEENGINE_H__
#define __GAMEENGINE_H__

//--------------------------------------------------------------------------------------------------------
#include "Common.h"

//--------------------------------------------------------------------------------------------------------
class GameEngine : public Engine
{

//--------------------------------------------------------------------------------------------------------
public:
	GameEngine( void* userdata [] );
	~GameEngine( void );
//--------------------------------------------------------------------------------------------------------
//### implement Engine:
public:
	/// init all resources
	result	Init( void );

	/// free all resources
	void	Free( void );

	/// game logic before render
	void	Exec( void );

	/// game logic after render
	void	Exec2( void );

	/// pre-render proccess
	void	PreRender( void );

	/// render
	void	Render( void );

	/// post-render proccess
	void	PostRender( void );

	/// display debug info
	void	DispDebugInfo( void );

	/// define anim table
	void	DefAnimTable( void );

	/// exit game
	void		ExitGame( void );

	//Rotate buffer
	void	ws_rotate_backbuffer(int16 *backbuffer);

	//emulate standard
	void	ws_emulate_standard(void);

//--------------------------------------------------------------------------------------------------------
public:
	void	EnterGame(s32 MapId);
	void	ReturnManiUI();
	void	PopMenu();
	void	ReadHightScore();
	s32		WriteHightScore(s32 HigSc);
	void	PlayMusic(u32 ID,bool bRep);
	void	StopMusic();
	void	PlaySound(u32 ID);
	void	StopAllSound();
	void	SaveCfg(void);
	void	LoadCfg(void);
	
	void PutPixel(int x, int y, u8 r, u8 g, u8 b);
	void PutPixel(int x, int y, int32 value);

//--------------------------------------------------------------------------------------------------------
//### data members:
public:
	bool		m_bUseAudio;

	AudioData*	m_pAudioData;
	s32			m_AudioCnt;

	//Surface
	int A320_SCREEN_WIDTH;
	int A320_SCREEN_HEIGHT;

	int			app_gameRunning;
	int			app_terminate;
	int			app_fullscreen;
	//TODO:INPUT
	//SDL_Event	app_input_event;
	int			app_rotated;

	//TODO:INPUT
	//SDL_Joystick *joystick=NULL;

	int			ws_videoEnhancementType;
	int			ws_colourScheme;
	int			ws_system;
	char		*ws_rom_path;
	char		old_rom_path[4096];

	uint32		 startTime, endTime, totalFrames;
	unsigned int nNormalLast;
	int			 nNormalFrac; 
	int			 nTime,nCount; 
	int			i;
	int			surfacePitch;

};
//--------------------------------------------------------------------------------------------------------

#endif//__GAMEENGINE_H__
