/* ================================================================
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 */ 

#include "../inc/GameEngine.h"

//Surface
int A320_SCREEN_WIDTH = 320;
int A320_SCREEN_HEIGHT = 240;

//--------------------------------------------------------------------------------------------------------
GameEngine::GameEngine( void* userdata [] ) : 
					Engine( userdata )
{
	m_pAudioData = NULL;
}
//--------------------------------------------------------------------------------------------------------
GameEngine::~GameEngine( void )
{
	Free();
}
//--------------------------------------------------------------------------------------------------------
/// init all resources
result	GameEngine::Init( void )
{
	InitDLRes();
	// 16 FPS
	SetFPS( 24 );

	return S2D_OK;
}
//--------------------------------------------------------------------------------------------------------
/// free all resources
void	GameEngine::Free( void )
{
	ReleaseDLRes();
	SAFE_DELETE_ARRAY( m_pAudioData );
}
//--------------------------------------------------------------------------------------------------------
/// game logic before render
void	GameEngine::Exec( void )
{
}
//--------------------------------------------------------------------------------------------------------
/// game logic after render
void	GameEngine::Exec2( void )
{
}
//--------------------------------------------------------------------------------------------------------
/// pre-render proccess
void	GameEngine::PreRender( void )
{

}
//--------------------------------------------------------------------------------------------------------
/// render
void	GameEngine::Render( void )
{
	//Pixel by pixel
	int r = 0;
	int g = 255;
	int b = 0;
	for(int i = 0; i < A320_SCREEN_HEIGHT;i++)
	{
		for (int j=0; j < A320_SCREEN_WIDTH; j++)
		{
			r+=1;
			PutPixel(i,j,r,g,b);
		}
		r += 1;
		g -= 1;
		b += 1;
	}

	//int r = 0;
	//int g = 255;
	//int b = 255;

	//int i = 0;
	//for(i = 0;i < (A320_SCREEN_WIDTH / 3);i++)
	//{
	//	for (int j=0; j < A320_SCREEN_WIDTH; j++)
	//	{
	//		PutPixel(i,j,r,g,b);
	//	}
	//	r+=1;
	//	g-=1;
	//	b-=1;
	//}
	//for(;i < (A320_SCREEN_WIDTH / 3) * 2;i++)
	//{
	//	for (int j=0; j < A320_SCREEN_WIDTH; j++)
	//	{
	//		PutPixel(i,j,r,g,b);
	//	}
	//	r-=1;
	//	g+=1;
	//	b+=1;
	//}
	//for(;i < (A320_SCREEN_WIDTH / 3) * 3;i++)
	//{
	//	for (int j=0; j < A320_SCREEN_WIDTH; j++)
	//	{
	//		PutPixel(i,j,r,g,b);
	//	}
	//	r+=1;
	//	g-=1;
	//	b-=1;
	//}
}
//--------------------------------------------------------------------------------------------------------
void	GameEngine::PostRender( void )
{
}

//--------------------------------------------------------------------------------------------------------
void	GameEngine::DispDebugInfo( void )
{
}

//--------------------------------------------------------------------------------------------------------
void	GameEngine::EnterGame( s32 MapId )
{ 
}
//--------------------------------------------------------------------------------------------------------
void	GameEngine::PlayMusic(u32 ID,bool bRep)
{
	if(!m_bUseAudio){
		return;
	}
	if(ID>=m_AudioCnt){
		return;
	}
	m_pAudioPlayer->Play(&m_pAudioData[ID],0,m_pAudioData[ID].GetLength(),255,bRep);
}

//--------------------------------------------------------------------------------------------------------
void	GameEngine::StopMusic()
{
	m_pAudioPlayer->Stop(0);
}

//--------------------------------------------------------------------------------------------------------
void	GameEngine::PlaySound(u32 ID)
{
	if(!m_bUseAudio){
		return;
	}
	if(ID>=m_AudioCnt){
		return;
	}
	for(s32 i=1;i<AudioPlayer::MaxChannels;i++){
		if(m_pAudioPlayer->GetState(i) != AUDIO_PLAYING){
			m_pAudioPlayer->Play(&m_pAudioData[ID],i,m_pAudioData[ID].GetLength(),255,false);
			return;
		}
	}
}	

//--------------------------------------------------------------------------------------------------------
void	GameEngine::StopAllSound()
{
	m_bUseAudio = false;

	m_pAudioPlayer->StopAll();
}

//--------------------------------------------------------------------------------------------------------
void	GameEngine::ExitGame( void )
{
	Exit();
}

//--------------------------------------------------------------------------------------------------------
void GameEngine::LoadCfg(void)
{
	// get full filename with path
	Char fullname[256];
	s2d::strcpy( fullname, _LS(".\\lltconfig.sdt") );

	FILE* m_fp = fopen( fullname, _LS("rb") );

	if(m_fp == NULL){
		return;
	}

	// read file to memory
	fseek( m_fp, 0, SEEK_END );
	s32 size =  ftell(m_fp);

	s32* mem = (s32*)  malloc( size );
	s32* pstar = mem;

	fseek(m_fp, 0, SEEK_SET );
	fread( mem, size,m_fp );
	fclose(m_fp);

	s32 Scene = *(s32*)mem;

	free( pstar );
}
//--------------------------------------------------------------------------------------------------------
void GameEngine::SaveCfg(void)
{
	// get full filename with path
	Char fullname[256];
	s2d::strcpy( fullname, _LS(".\\lltconfig.sdt") );

	FILE* m_fp = fopen( fullname, _LS("wb+") );

	if(m_fp == NULL){
		return;
	}

	s32 Scene=5;
	fwrite(&Scene, sizeof(s32),m_fp );

	// close file
	fclose(m_fp);
}
//--------------------------------------------------------------------------------------------------------
void GameEngine::PutPixel(int x, int y, u8 r,u8 g, u8 b )
{
	Pixel* ptr = m_pDraw2D->GetVRAMPtr();
	Pixel color1(r,g,b);
	s32 ofs = (x*A320_SCREEN_WIDTH) + (y);

	ptr[ofs] = color1;
}