/* ================================================================
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 */ 



#ifndef __GAMEENGINE_H__
#define __GAMEENGINE_H__

//--------------------------------------------------------------------------------------------------------
#include "Common.h"

//--------------------------------------------------------------------------------------------------------
class GameEngine : public Engine
{
//--------------------------------------------------------------------------------------------------------
public:
	GameEngine( void* userdata [] );
	~GameEngine( void );
//--------------------------------------------------------------------------------------------------------
//### implement Engine:
public:
	/// init all resources
	result	Init( void );

	/// free all resources
	void	Free( void );

	/// game logic before render
	void	Exec( void );

	/// game logic after render
	void	Exec2( void );

	/// pre-render proccess
	void	PreRender( void );

	/// render
	void	Render( void );

	/// post-render proccess
	void	PostRender( void );

	/// display debug info
	void	DispDebugInfo( void );

	/// define anim table
	void	DefAnimTable( void );

	/// exit game
	void		ExitGame( void );

//--------------------------------------------------------------------------------------------------------
public:
	void	EnterGame(s32 MapId);
	void	ReturnManiUI();
	void	PopMenu();
	void	ReadHightScore();
	s32		WriteHightScore(s32 HigSc);
	void	PlayMusic(u32 ID,bool bRep);
	void	StopMusic();
	void	PlaySound(u32 ID);
	void	StopAllSound();
	void	SaveCfg(void);
	void	LoadCfg(void);

//--------------------------------------------------------------------------------------------------------
//### data members:
public:
	// shaders
	FadeShader*	m_pFadeShader;
	
	Texture* m_pImgS2d;
	Texture* m_pImgS2d_alpha;

	bool			m_bUseAudio;

	s32			m_iHigScore[5];
	s32			m_iScoreScene[5];
	s32			m_iNewSceneIdex;

	AudioData*	m_pAudioData;
	s32			m_AudioCnt;

	LanguageType		m_iLanguage;
};
//--------------------------------------------------------------------------------------------------------

#endif//__GAMEENGINE_H__
