/* ======================================================================
* THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
* IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* ====================================================================== */ 


#ifndef __SCENE_H__
#define __SCENE_H__

//--------------------------------------------------------------------------------------------------------
#include "Common.h"
#include "Bubble.h"

class GameEngine;
//--------------------------------------------------------------------------------------------------------
class Scene
{
public:
	Scene( void );
	~Scene( void );

public:
	/// init scene
	bool	Init( Input* pInput );

	/// init scene
	void	Reset();

	/// free scene
	void	Free( void );

	/// Draw scene
	void	Draw( Draw2D* pDraw2d );

	/// update scene;
	void	Exec( void );

	Input*	GetInput( void );
	void	LoadAnim( const Char* name, AniData& data );
	void	NewGame( Difficulty diff );
	void	EndGame();
	void	FaidedGame();
	void	CreateLine( s32 r );
	void	UpDataMenu( );
	void	DrawMenu( Draw2D* pDraw2d );
	void	PopBubble( s32 c, s32 r );
	s32		CountSamePop( s32 c, s32 r, s32 color);
	void	DropBubble( void );
	bool	MarkDrop( s32 c, s32 r );
	void	CaleShoot();
	void	ControlAngles( void );
	void	GetBubbleCenter( s32 c, s32 r, f32& x, f32& y );	
	void	GetBubblePos( s32& c, s32& r, f32 x, f32 y );	
	s32	Rand( s32 min, s32 max );
	s32	TraceWall( f32 x, f32 y, f32 &x2, f32 &y2, f32& speedx, f32& speedy );
	bool	TraceBubble( f32 x, f32 y, f32 &x2, f32 &y2 );
	bool	TraceBottom( Bubble* pBubble );
	void	BubbleStop( Bubble* pBubble );
	void	DrawCaleLine( Draw2D* pDraw2d );
	bool	CaleNewBubble( void );
	void	SaveBubble( void );
	void	Levelup( void );
	void	ReadHightScore();
	void	WriteHightScore(s32 HigSc);
	void	DrawDigital( Draw2D* pDraw2d, s32 digital, s32 x, s32 y, s32 type );
	void	ReadConfig( void );
private:

	//--------------------------------------------------------------------------------------------------------
	//### data members:
public:

	enum{
		m_iMaxColorCnt = 7,
	};

	SceneState	m_eState;
	SceneState	m_eStateTemp;

	Rect	m_SceneRect;

	s32	m_iScore;

	s32	m_iLevel;

	s32	m_iAddScore;

	s32	m_iAddScX;
	s32	m_iAddScY;
	s32	m_iAddCnt;

	f32	m_fRadius;

	f32	m_fDiameter;

	Difficulty	m_eDifficulty;

	s32	m_iGrowTime;
	s32	m_iCntGrow;

	s32	m_bShowUI;

	s32	m_UICurSele;

	s32	m_nOfColumns;

	s32	m_nOfRows;

	s32	m_level;

	s32	m_nOfBubble;

	Bubble*	m_pBubbleBuffer;

	Bubble	m_CaleBubble;

	Bubble	m_ReadyBubble[2];

	//Bubble	m_NewBubble;
	s32	m_iCaleCnt;
	s32	m_iCntNewBubble;

	Bubble	m_SaveBubble;

	AniData	m_BubblePalce;

	s32	m_iAngles;

	f32	m_fCaleSpeed;

	Texture*	m_pTexCaleLine;

	s32	m_iWaitTime;

	s32	m_newBubleC;
	s32	m_newBubleR;

	s32	m_iCurColorCnt;


	AniData	m_BubbeAnim[ m_iMaxColorCnt ];
	AniData	m_BubbePopAnim[ m_iMaxColorCnt ];
	AniData	m_BubbeFailedAnim[ m_iMaxColorCnt ];
	AniData	m_AniTable[ MAX_ANIMATION ];

	Animation	m_AnimationTable[ MAX_ANIMATION ];

	s32	m_bAllClear;

	Texture*	m_pTexBack;
	Texture*	m_pTexLogo;
	Texture*	m_pTexHS;

	/// input
	Input*	m_pInput;

	///
	GameEngine* m_pEng;

	RandomGenerator	m_rand;

	s32	m_iCntHS;
	s32	m_iNewScoreIdex;
	s32*	m_iHightScore;
	s32	m_iFramCnt1;

	Texture*	m_pDigital[4];

};

#endif//__SCENE_H__
