/* ======================================================================
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================== */ 


#ifndef __ANIMATION_H__
#define __ANIMATION_H__

//--------------------------------------------------------------------------------------------------------
#include "Common.h"

//--------------------------------------------------------------------------------------------------------
class Animation
{
public:
	Animation( void );
	~Animation( void );

public:
	void	Draw( Draw2D*	pDraw2D, s32 x, s32 y );
	void	DrawLF( Draw2D*	pDraw2D, s32 x, s32 y );
	void	Exec( void );
	bool	IsAnimOver( void );
	void	Reset( void );
	void	Clone( Animation& anim );

public:
	AniData*	m_pData;
	
	s32	m_iCurFrame;

	s32	m_bLoop;
};

#endif//__ANIMATION_H__
