/* ======================================================================
* THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
* IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* ====================================================================== */ 

#ifndef __TEXTUREMANAGER_H__
#define __TEXTUREMANAGER_H__

//--------------------------------------------------------------------------------------------------------
#include "Common.h"

//--------------------------------------------------------------------------------------------------------
struct TexSlot
{
	Char	name[256];	// texture handle
	Texture	tex;	// texture
};

//--------------------------------------------------------------------------------------------------------
class TextureManager
{

	//--------------------------------------------------------------------------------------------------------
	//### interfaces:
public:
	TextureManager( void );
	~TextureManager( void );

	/// find texture, will auto load if it's not exist
	Texture*	FindOrLoadTexture( const Char* fname, const Char* path = NULL );

	/// free all textures
	void	FreeAll( void );

	//--------------------------------------------------------------------------------------------------------
	//### data members:
private:
	// current texture count
	s32	m_nbTextures;

	// texture pool
	TexSlot	m_TexturePool[MAX_TEXTURES];
};
//--------------------------------------------------------------------------------------------------------

#endif//__S2DENGINE_BSPTEXTUREMANAGER_H__
